<?php
/*
                         ''~``
                        ( o o )
+------------------.oooO--(_)--Oooo.------------------+
|                    Unreal Portal                    |
|                    .oooO                            |
|                    (   )   Oooo.                    |
+---------------------\ (----(   )--------------------+
                       \_)    ) /
                             (_/


           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
           |The Logo Looks Best in Courier New|
           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

                       ---====---
                      Unreal Portal
                       By Cricket
*/

if ( ! defined( 'IN_ACP' ) )
{
    print "<h1>Incorrect access</h1>You cannot access this file directly.";
    exit();
}

class admin_uportal_uportal_uportal extends ipsCommand
{
    /**
     * Skin object
     *
     * @access  private
     * @var     object          Skin templates
     */
    private $html;

    private $globals = array();

    public function doExecute( ipsRegistry $registry ) 
    {
        //-----------------------------------------
        // Load HTML
        //-----------------------------------------
        
        $this->html = $this->registry->output->loadTemplate( 'cp_skin_uportal' );

        switch($this->request['do'])
        {
            case 'organize_blocks':
                $this->organize_blocks();
                break;

            case 'do_organize_blocks':
                $this->do_organize_blocks();
                break;

            case 'add_custom_block':
                $this->add_custom_block();
                break;

            case 'do_add_custom_block':
                $this->do_add_custom_block();
                break;

            case 'edit_del_custom_blocks':
                $this->edit_del_custom_blocks();
                break;

            case 'edit_custom_block':
                $this->edit_custom_block();
                break;

            case 'do_edit_custom_block':
                $this->do_edit_custom_block();
                break;

            case 'delete_custom_block':
                $this->delete_custom_block();
                break;

            case 'add_custom_content':
                $this->add_custom_content();
                break;

            case 'do_add_custom_content':
                $this->do_add_custom_content();
                break;
                 
            case 'edit_del_custom_content':
                $this->edit_del_custom_content();
                break;

            case 'edit_custom_content':
                $this->edit_custom_content();
                break;

            case 'do_edit_custom_content':
                $this->do_edit_custom_content();
                break;
                
            case 'delete_custom_content':
                $this->delete_custom_content();
                break;

            case 'do_portal_main':
                $this->do_portal_main();
                break;

            case 'portal_main':
            default:
                $this->portal_main();
                break;
        }

        $this->registry->getClass('output')->html_main .= $this->registry->getClass('output')->global_template->global_frame_wrapper();
        $this->registry->getClass('output')->sendOutput();
    }
    
    function portal_main()
    {
        $this->registry->output->html .= $this->html->section_title("Portal Main");

        $top_polls[]=array(0,"Show no poll");
        $top_polls[]=array(0,"-----------------------");

        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'topics',
            'where'     => 'poll_state <> 0 ORDER BY tid DESC' 
        ));
        $query = $this->DB->execute();

        while( $poll = $this->DB->fetch($query) )
        {
            $top_polls[]=array($poll['tid'],$poll['tid']." - ".$poll['title']);
        }

        $form_array = array();
        
        $this->DB->build( array( 
            'select'    => 'id, name',
            'from'      => 'forums',
            'where'     => 'sub_can_post = 1' 
        ));
        $query = $this->DB->execute();

        while( $r = $this->DB->fetch($query) )
        {
            $form_array[] = array( $r['id'], $r['name'] );
        }

        //Querying Blocks From The Portal
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'unrealportal',
            'order'     => 'order2 asc' 
        ));
        $query = $this->DB->execute();
        
        while( $Data = $this->DB->fetch($query) )
        {
            if($Data['custblock_id'] == 0)
                $this->globals['block'][$Data['name']] = $Data['show'];
            else
                $this->globals['block']["cb_{$Data['custblock_id']}"] = $Data['show'];
        }

        //Querying Settings From The Portal
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_settings',
            'order'     => 'name asc' 
        ));
        $query = $this->DB->execute();

        while( $Data = $this->DB->fetch($query) )
        {
            $this->globals['setting'][$Data['name']] = $Data['value'];
        }

        if($this->globals['setting']['left'] == null)
        $this->globals['setting']['left'] = "21%";

        if($this->globals['setting']['leftcustom'] == null)
        $this->globals['setting']['leftcustom'] = "21%";

        if($this->globals['setting']['middle'] == null)
        $this->globals['setting']['middle'] = "51%";

        if($this->globals['setting']['right'] == null)
        $this->globals['setting']['right'] = "21%";

        if($this->globals['setting']['rightcustom'] == null)
        $this->globals['setting']['rightcustom'] = "21%";

        $form_array[] = array (0, "None, I use the field below");

        $this->registry->output->html .= $this->html->start_form( array(
            1 => array( 'do'        , 'do_portal_main'  ),
            2 => array( 'module'    , 'uportal'         ),
            3 => array( 'section'   , 'uportal'         ),
        ) );


        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Columns" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Left column width?</b>" ,

        $this->registry->getClass('output')->formInput( "left", $this->globals['setting']['left']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Left custom content column width?</b>" ,

        $this->registry->getClass('output')->formInput( "leftcustom", $this->globals['setting']['leftcustom']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Middle column width?</b>" ,
        $this->registry->getClass('output')->formInput( "middle", $this->globals['setting']['middle']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Middle custom content column width?</b>" ,
        $this->registry->getClass('output')->formInput( "middlecustom", $this->globals['setting']['middlecustom']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Right column width?</b>" ,
        $this->registry->getClass('output')->formInput( "right", $this->globals['setting']['right']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Right custom content column width?</b>" ,
        $this->registry->getClass('output')->formInput( "rightcustom", $this->globals['setting']['rightcustom']  )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Poll" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Portal Poll</b><div class='desctext'>Select a thread (only threads WITH a poll are shown).</div>" ,
        $this->registry->getClass('output')->formDropdown( "poll", $top_polls , $this->globals['setting']['poll'] )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "News" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show News?</b>" ,
        $this->registry->getClass('output')->formYesNo( "news", $this->globals['block']['news']  )

        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Export news topics from which forum?</b>" ,
        $this->registry->getClass('output')->formDropdown( "newsforum", $form_array, $this->globals['setting']['newsforum']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Export news from multiple forums?</b><div class='desctext'>Enter forum ID's, seperate by a comma (,)</div>" ,
        $this->registry->getClass('output')->formInput( "newsforum_expert", $this->globals['setting']['newsforum_expert']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>How much News Items to show at the front page?</b>" ,
        $this->registry->getClass('output')->formInput( "newsposts", $this->globals['setting']['newsposts']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Limit news post height?</b>" ,
        $this->registry->getClass('output')->formYesNo( "newsforum_height", $this->globals['setting']['newsforum_height']  )

        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Limit news post height to?</b>" ,
        $this->registry->getClass('output')->formInput( "newsforum_height_limit", $this->globals['setting']['newsforum_height_limit']  )

        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Limit news post width to portal block width?</b>" ,
        $this->registry->getClass('output')->formYesNo( "newsforum_width", $this->globals['setting']['newsforum_width']  )

        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Limit news to x characters?</b>" ,
        $this->registry->getClass('output')->formYesNo( "tease_news", $this->globals['setting']['tease_news']  )

        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Number of characters to limit news to?</b><div class='desctext'>Note that this WILL break any HTML tags if they haven't been closed at the end of x characters</div>" ,
        $this->registry->getClass('output')->formInput( "tease_length", $this->globals['setting']['tease_length']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Latest News?</b>" ,
        $this->registry->getClass('output')->formYesNo( "latest_news", $this->globals['block']['latest_news']  )

        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Number of Latest News Items to display:</b>" ,
        $this->registry->getClass('output')->formInput( "num_latest_news", $this->globals['setting']['num_latest_news']  )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Calendar" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Calendar (Big Version)?</b>" ,
        $this->registry->getClass('output')->formYesNo( "calendar", $this->globals['block']['calendar']  )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Latest" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Latest Threads (Small Version)?</b>" ,
        $this->registry->getClass('output')->formYesNo( "latest_posts", $this->globals['block']['latest_posts']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Number of Latest Threads (Small Version) to show?</b>" ,
        $this->registry->getClass('output')->formInput( "num_latestposts", $this->globals['setting']['num_latestposts']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Latest Threads (Big Version)?</b>" ,
        $this->registry->getClass('output')->formYesNo( "latest_posts_big", $this->globals['block']['latest_posts_big']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Number of Latest Threads (Big Version) to show?</b>" ,
        $this->registry->getClass('output')->formInput( "num_latestposts_big", $this->globals['setting']['num_latestposts_big']  )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Login Box" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Login Box (if NOT logged in)?</b>" ,
        $this->registry->getClass('output')->formYesNo( "loginbox", $this->globals['block']['loginbox']  )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Main Statistics" );
        
        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Statistics?</b>" ,
        $this->registry->getClass('output')->formYesNo( "stats", $this->globals['block']['stats']  )
        )      );

        /*
        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Statistics?</b>
        <div class='desctext'>If set to no, then the rest of the settings will be ignored.</div>" ,
        $this->registry->getClass('output')->formYesNo( "stats", $this->globals['block']['stats']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Active Members?</b>" ,
        $this->registry->getClass('output')->formYesNo( "activemembers", $this->globals['setting']['activemembers']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show #Topics, #Members, etc.?</b>" ,
        $this->registry->getClass('output')->formYesNo( "post_stats", $this->globals['setting']['post_stats']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Calendar Events?</b>" ,
        $this->registry->getClass('output')->formYesNo( "calendar_events", $this->globals['setting']['calendar_events']  )
        )      );
        */

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Other  Statistics" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Top Posters (Hall of Fame)?</b>" ,
        $this->registry->getClass('output')->formYesNo( "top_posters", $this->globals['block']['top_posters']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Number of Top Posters to show?</b>" ,
        $this->registry->getClass('output')->formInput( "num_topposters", $this->globals['setting']['num_topposters']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show New Members?</b>" ,
        $this->registry->getClass('output')->formYesNo( "new_members", $this->globals['block']['new_members']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Number of New Members to show?</b>" ,
        $this->registry->getClass('output')->formInput( "num_newmembers", $this->globals['setting']['num_newmembers']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Top Forums?</b>" ,
        $this->registry->getClass('output')->formYesNo( "top_forums", $this->globals['block']['top_forums']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>How many Forums to display?</b>" ,
        $this->registry->getClass('output')->formInput( "num_top_forums", $this->globals['setting']['num_top_forums']  )
        )      );

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Custom Blocks" );

        $count = 0;

        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_custblocks'
        ));
        $query = $this->DB->execute();

        while( $customblocks = $this->DB->fetch($query) )
        {
            $blockname[$count] = "cb_{$customblocks['id']}";
            $blocktitle[$count] = $customblocks['title'];

            $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show {$blocktitle[$count]}?</b>" ,
            $this->registry->getClass('output')->formYesNo( $blockname[$count], $this->globals['block'][$blockname[$count]]  )

            )      );
            $count++;

        }

        $this->registry->output->html .= $this->html->end_table();

        $this->html->td_header[] = array( "&nbsp;"   , "40%" );
        $this->html->td_header[] = array( "&nbsp;"   , "60%" );

        $this->registry->output->html .= $this->html->start_table( "Custom Content" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Show Custom Content Links?</b>" ,
        $this->registry->getClass('output')->formYesNo( "custom_content", $this->globals['block']['custom_content']  )
        )      );
         
        $this->registry->output->html .= $this->html->end_form("Edit Portal");
         
        $this->registry->output->html .= $this->html->end_table();
    }
    
    function do_portal_main()
    {
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'unrealportal',
            'order'     => 'order2 asc'
        ));
        $query1 = $this->DB->execute();

        while( $Data = $this->DB->fetch($query1) )
        {
            if($this->request[$Data['name']] != $Data['show'])
            {
                if($Data['custblock_id'] == 0)
                {
                    if($this->request[$Data['name']] == "")
                        $this->request[$Data['name']] = 0;

                    $this->DB->update( 'unrealportal', array( '`show`' => $this->request[$Data['name']] ), 'name="'.$Data['name'].'"' );
                }
                else
                {
                    if($this->request["cb_{$Data['custblock_id']}"] == "")
                        $this->request["cb_{$Data['custblock_id']}"] = 0;

                    $this->DB->update( 'unrealportal', array( '`show`' => $this->request["cb_{$Data['custblock_id']}"] ), "id={$Data['id']}" );
                }
            }
        }

        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_settings',
            'order'     => 'name asc'
        ));
        $query2 = $this->DB->execute();

        while( $Data = $this->DB->fetch($query2) )
        {
            if($this->request[$Data['name']] != $Data['value'])
            {
                $this->DB->update( 'up_settings', array( 'value' => $this->request[$Data['name']] ), 'name="'.$Data['name'].'"' );
            }
        }

        $this->cache();

        $this->DB->optimize( 'unrealportal' );
        $this->DB->optimize( 'up_settings' );
        
        $this->registry->output->global_message = "Unreal Portal Updated";
        $this->portal_main();
    }
    
    function organize_blocks()
    {
        $this->registry->output->html .= $this->html->section_title("Organize Blocks");

        $button      = "Submit Layout";

        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'unrealportal',
            'where'     => '`show` != 0',
            'order'     => 'order2 asc'
        ));
        $query = $this->DB->execute();

        while( $Data = $this->DB->fetch($query) )
        {
            $option_name = $Data['title'];
            $option_value = $Data['id'];
            $align_col = $Data['align'];

            switch($align_col)
            {
                case 'left':
                    $l_col_array[count($l_col_array)+1] = array( $option_value, $option_name);
                    break;
                case 'middle':
                    $m_col_array[count($m_col_array)+1] = array( $option_value, $option_name);
                    break;
                case 'right':
                    $r_col_array[count($r_col_array)+1] = array( $option_value, $option_name);
                    break;
                case 'top':
                    $t_col_array[count($t_col_array)+1] = array( $option_value, $option_name);
                    break;
                case 'bottom':
                    $b_col_array[count($b_col_array)+1] = array( $option_value, $option_name);
                    break;
            }
        }

        if(!($l_col_array))
        $l_col_array[-2] = array(0, 'None');

        if(!($m_col_array))
        $m_col_array[-2] = array(0, 'None');

        if(!($r_col_array))
        $r_col_array[-2] = array(0, 'None');

        if(!($t_col_array))
        $t_col_array[-2] = array(0, 'None');

        if(!($b_col_array))
        $b_col_array[-2] = array(0, 'None');

        $this->registry->output->html .= "<script type=\"text/javascript\" src='{$this->settings['js_app_url']}uportal_layout.js'></script>";
        
        $this->registry->output->html .= $this->html->start_form( array(
            1 => array( 'do'        , 'do_organize_blocks'  ),
            2 => array( 'module'    , 'uportal'             ),
            3 => array( 'section'   , 'uportal'             ),
            4 => array( 'layout_l'  , ''                    ),
            5 => array( 'layout_m'  , ''                    ),
            6 => array( 'layout_r'  , ''                    ),
            7 => array( 'layout_t'  , ''                    ),
            8 => array( 'layout_b'  , ''                    ),
        ) );

        $layout_l_control .= $this->registry->getClass('output')->formInput('left_up', "Up", "", "", "button", "OnClick='moveUpList(this.form.layout_l_col);'");
        $layout_l_control .= $this->registry->getClass('output')->formInput('left_down', "Down", "", "", "button", "OnClick='moveDownList(this.form.layout_l_col);'") . "<br />";
        $layout_l_control .= $this->registry->getClass('output')->formInput('left_top', 'Top', "", "", "button", "OnClick='addItems(this.form.layout_l_col, this.form.layout_t_col); removeItems(this.form.layout_l_col);'");
        $layout_l_control .= $this->registry->getClass('output')->formInput('left_bottom', 'Bottom', "", "", "button", "OnClick='addItems(this.form.layout_l_col, this.form.layout_b_col); removeItems(this.form.layout_l_col);'");

        $layout_m_control .= $this->registry->getClass('output')->formInput('mid_up', "Up", "", "", "button", "OnClick='moveUpList(this.form.layout_m_col);'");
        $layout_m_control .= $this->registry->getClass('output')->formInput('mid_down', "Down", "", "", "button", "OnClick='moveDownList(this.form.layout_m_col);'") . "<br />";
        $layout_m_control .= $this->registry->getClass('output')->formInput('mid_top', 'Top', "", "", "button", "OnClick='addItems(this.form.layout_m_col, this.form.layout_t_col); removeItems(this.form.layout_m_col);'");
        $layout_m_control .= $this->registry->getClass('output')->formInput('midbottom', 'Bottom', "", "", "button", "OnClick='addItems(this.form.layout_m_col, this.form.layout_b_col); removeItems(this.form.layout_m_col);'");

        $layout_r_control .= $this->registry->getClass('output')->formInput('right_up', "Up", "", "", "button", "OnClick='moveUpList(this.form.layout_r_col);'");
        $layout_r_control .= $this->registry->getClass('output')->formInput('right_down', "Down", "", "", "button", "OnClick='moveDownList(this.form.layout_r_col);'") . "<br />";
        $layout_r_control .= $this->registry->getClass('output')->formInput('right_top', 'Top', "", "", "button", "OnClick='addItems(this.form.layout_r_col, this.form.layout_t_col); removeItems(this.form.layout_r_col);'");
        $layout_r_control .= $this->registry->getClass('output')->formInput('right_bottom', 'Bottom', "", "", "button", "OnClick='addItems(this.form.layout_r_col, this.form.layout_b_col); removeItems(this.form.layout_r_col);'");

        $layout_t_control .= $this->registry->getClass('output')->formInput('top_up', "Up", "", "", "button", "OnClick='moveUpList(this.form.layout_t_col);'");
        $layout_t_control .= $this->registry->getClass('output')->formInput('top_down', "Down", "", "", "button", "OnClick='moveDownList(this.form.layout_t_col);'") . "<br />";
        $layout_t_control .= $this->registry->getClass('output')->formInput('top_mid', 'Left', "", "", "button", "OnClick='addItems(this.form.layout_t_col, this.form.layout_l_col); removeItems(this.form.layout_t_col);'");
        $layout_t_control .= $this->registry->getClass('output')->formInput('top_mid', 'Middle', "", "", "button", "OnClick='addItems(this.form.layout_t_col, this.form.layout_m_col); removeItems(this.form.layout_t_col);'");
        $layout_t_control .= $this->registry->getClass('output')->formInput('top_mid', 'Right', "", "", "button", "OnClick='addItems(this.form.layout_t_col, this.form.layout_r_col); removeItems(this.form.layout_t_col);'");

        $layout_b_control .= $this->registry->getClass('output')->formInput('bottom_up', "Up", "", "", "button", "OnClick='moveUpList(this.form.layout_b_col);'");
        $layout_b_control .= $this->registry->getClass('output')->formInput('bottom_down', "Down", "", "", "button", "OnClick='moveDownList(this.form.layout_b_col);'") . "<br />";
        $layout_b_control .= $this->registry->getClass('output')->formInput('bottom_mid', 'Left', "", "", "button", "OnClick='addItems(this.form.layout_b_col, this.form.layout_l_col); removeItems(this.form.layout_b_col);'");
        $layout_b_control .= $this->registry->getClass('output')->formInput('bottom_mid', 'Middle', "", "", "button", "OnClick='addItems(this.form.layout_b_col, this.form.layout_m_col); removeItems(this.form.layout_b_col);'");
        $layout_b_control .= $this->registry->getClass('output')->formInput('bottom_mid', 'Right', "", "", "button", "OnClick='addItems(this.form.layout_b_col, this.form.layout_r_col); removeItems(this.form.layout_b_col);'");


        $layout_lm_control .= $this->registry->getClass('output')->formInput('lm_right', '>>', "", "", "button", "OnClick='addItems(this.form.layout_l_col, this.form.layout_m_col); removeItems(this.form.layout_l_col);'") . "<br />";
        $layout_lm_control .= $this->registry->getClass('output')->formInput('lm_left', '<<', "", "", "button", "OnClick='addItems(this.form.layout_m_col, this.form.layout_l_col); removeItems(this.form.layout_m_col);'");

        $layout_mr_control .= $this->registry->getClass('output')->formInput('mr_right', '>>', "", "", "button", "OnClick='addItems(this.form.layout_m_col, this.form.layout_r_col); removeItems(this.form.layout_m_col);'") . "<br />";
        $layout_mr_control .= $this->registry->getClass('output')->formInput('mr_left', '<<', "", "", "button", "OnClick='addItems(this.form.layout_r_col, this.form.layout_m_col); removeItems(this.form.layout_r_col);'");

        $this->registry->output->html .= "
<div class='acp-box'>
    <h3>Organize Blocks</h3>
        <table class='alternate_rows' width='100%'>
            <tr>
                <th width='100%' style='text-align: center' colspan='5'>Top Column</th>
            </tr>";

        $this->registry->output->html .= "<tr><td colspan='5' class='tdrow1'  valign='middle'><div align='center'>" .
        $this->registry->getClass('output')->formMultiDropdown( "layout_t_col", $t_col_array, NULL, 10, 50 ) . "</div></td></tr>";

        $this->registry->output->html .= "<td colspan='5' class='tdrow1'  valign='middle'><div align='center'>"
        . $layout_t_control . "</div></td>";

        $this->registry->output->html .= "
            <tr>
                <th width='33%' style='text-align: center'>Left Column</th>
                <th width='1%'></td>
                <th width='33%'style='text-align: center'>Middle Column</th>
                <th width='1%'></td>
                <th width='32%' style='text-align: center'>Right Column</th>
            </tr>
";

        $this->registry->output->html .= $this->html->add_td_row( array(
      "<div align='center'>" . $this->registry->getClass('output')->formMultiDropdown( "layout_l_col", $l_col_array, NULL, 10 ) . "</div>",
      "<div align='center'>" . $layout_lm_control . "</div>",
      "<div align='center'>" . $this->registry->getClass('output')->formMultiDropdown( "layout_m_col", $m_col_array, NULL, 10 ) . "</div>",
      "<div align='center'>" . $layout_mr_control . "</div>",
      "<div align='center'>" . $this->registry->getClass('output')->formMultiDropdown( "layout_r_col", $r_col_array, NULL, 10 ) . "</div>"
      )
      );

      $this->registry->output->html .= $this->html->add_td_row( array(
      "<div align='center'>" . $layout_l_control . "</div>",
      "&nbsp;",
      "<div align='center'>" . $layout_m_control . "</div>",
      "&nbsp;",
      "<div align='center'>" . $layout_r_control . "</div>"
      )
      );

      $this->registry->output->html .= "
            <tr>
                <th width='100%' style='text-align: center' colspan='5'>Bottom Column</th>
            </tr>";

      $this->registry->output->html .= "<tr><td colspan='5' class='tdrow1'  valign='middle'><div align='center'>" .
      $this->registry->getClass('output')->formMultiDropdown( "layout_b_col", $b_col_array, NULL, 10, 50 ) . "</div></td></tr>";

      $this->registry->output->html .= "<td colspan='5' class='tdrow1'  valign='middle'><div align='center'>"
      . $layout_b_control . "</div></td>";

      $this->registry->output->html .= "
    <tr>
        <td align='center' colspan='5' width='100%'>
            <input class='realbutton' type='submit' value='Submit Layout' 
            OnClick='this.form.layout_l.value = makeStringFromSelect(this.form.layout_l_col); 
            this.form.layout_m.value = makeStringFromSelect(this.form.layout_m_col); 
            this.form.layout_r.value = makeStringFromSelect(this.form.layout_r_col);
            this.form.layout_t.value = makeStringFromSelect(this.form.layout_t_col);
            this.form.layout_b.value = makeStringFromSelect(this.form.layout_b_col);' id='button' accesskey='s'>
        </td>
    </tr>";

      $this->registry->output->html .= "
        </table>
    </div>
</div>
";
    }
    
    function do_organize_blocks()
    {
        $order = array();

        $layout_1 = array();
        $layout_m = array();
        $layout_r = array();
        $layout_t = array();
        $layout_b = array();

        foreach( $_POST as $key=>$value )
        {
            if( preg_match("#layout_[lmrtb]#", $key ) )
            {
                switch ($key)
                {
                    case "layout_l":
                        $layout_l = explode(",", $value);
                        break;
                    case "layout_m":
                        $layout_m = explode(",", $value);
                        break;
                    case "layout_r":
                        $layout_r = explode(",", $value);
                        break;
                    case "layout_t":
                        $layout_t = explode(",", $value);
                        break;
                    case "layout_b":
                        $layout_b = explode(",", $value);
                        break;
                }
            }
        }
        unset($key);
        unset($value);

        foreach( $layout_l as $key=>$value )
        {
            $this->DB->update( 'unrealportal', array( 'align' => 'left', 'order2' => $key+1 ), "id='{$value}'" );
        }
        foreach( $layout_m as $key=>$value )
        {
            $this->DB->update( 'unrealportal', array( 'align' => 'middle', 'order2' => $key+1 ), "id='{$value}'" );
        }
        foreach( $layout_r as $key=>$value )
        {
            $this->DB->update( 'unrealportal', array( 'align' => 'right', 'order2' => $key+1 ), "id='{$value}'" );
        }
        foreach( $layout_t as $key=>$value )
        {
            $this->DB->update( 'unrealportal', array( 'align' => 'top', 'order2' => $key+1 ), "id='{$value}'" );
        }
        foreach( $layout_b as $key=>$value )
        {
            $this->DB->update( 'unrealportal', array( 'align' => 'bottom', 'order2' => $key+1 ), "id='{$value}'" );
        }

        $this->cache();

        $this->registry->output->global_message = "Blocks Organized";
        $this->organize_blocks();
    }
    
    function add_custom_block()
    {
        $base_block_html = <<<EOF

<table class='ipb_table' cellspacing="1">
    <tbody>
        <tr>
            <td class='row2'>

<!-- This is the default custom block template. You can either replace this comment tag with your own content to create a simple custom block or you can remove the entire content and have your own formatting-->

            </td>
        </tr>
    </tbody>
</table>
EOF;

        $this->registry->output->html .= $this->html->section_title("Add Custom Block");

        $this->registry->output->html .= $this->html->start_form( array(
            1 => array( 'do'            , 'do_add_custom_block'             ),
            2 => array( 'module'        , 'uportal'                         ),
            3 => array( 'section'       , 'uportal'                         ),
        ) );

        //+-------------------------------

        $this->html->td_header[] = array( "&nbsp;"  , "40%" );
        $this->html->td_header[] = array( "&nbsp;"  , "60%" );

        //+-------------------------------

        $this->registry->output->html .= $this->html->start_table( "Add A Block" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Block Title:</b><div class='desctext'>This is the title of the block that's shown on the site</div>" ,
        $this->registry->getClass('output')->formInput( "block_title" )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Block PHP/HTML:</b><div class='desctext'>Be sure to put the php code in between the &lt;?php and ?&gt; tags</div>" ,
        $this->registry->getClass('output')->formTextarea("block_html", $base_block_html, "70", "30" )
        ),"","top");
         
        $this->registry->output->html .= $this->html->end_form('Add A Block');
         
        $this->registry->output->html .= $this->html->end_table();
    }
    
    function do_add_custom_block()
    {
        $total = 0;
        
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'unrealportal',
            'order'     => 'order2 asc'
        ));
        $query = $this->DB->execute();

        while( $fetch = $this->DB->fetch($query) )
        {
            $total++;
        }
        $total += 1;

        $align = "left";

        $blockhtml = stripslashes($_POST['block_html']);
        
        $this->DB->insert( 'up_custblocks', array( 'title' => $this->request['block_title'], 'html' => $blockhtml ) );
        $newid = $this->DB->getInsertId();
        
        $this->DB->insert( 'unrealportal', array( 'title' => $this->request['block_title'], 'align' => $align, 'order2' => $total, 'custblock_id' => $newid) );

        $this->cache();

        $this->registry->output->global_message = "Custom Block Added";
        $this->add_custom_block();
    }
    
    function edit_del_custom_blocks()
    {
        $this->registry->output->html .= $this->html->section_title("Edit/Delete Custom Blocks");

        //+-------------------------------

        $this->html->td_header[] = array( "Title"   , "34%" );
        $this->html->td_header[] = array( "Edit"    , "33%" );
        $this->html->td_header[] = array( "Delete"  , "33%" );

        //+-------------------------------

        $this->registry->output->html .= $this->html->start_table( "Edit/Delete Custom Blocks" );

        $i=0;
        
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_custblocks' 
        ));
        $query = $this->DB->execute();

        while( $Data = $this->DB->fetch($query) )
        {
            $i++;

            $this->registry->output->html .= $this->html->add_td_row( array(
                                                          "<center><b>{$Data['title']}</b></center>",
                                                          "<center><a href='{$this->settings['base_url']}module=uportal&section=uportal&do=edit_custom_block&id={$Data['id']}'>Edit</a></center>",
                                                          "<center><a href='{$this->settings['base_url']}module=uportal&section=uportal&do=delete_custom_block&id={$Data['id']}'>Delete</a></center>",
            )      );
        }
         
        $this->registry->output->html .= $this->html->end_table();
    }
    
    function edit_custom_block()
    {
        $this->registry->output->html .= $this->html->section_title("Edit Custom Block");
        
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_custblocks',
            'where'     => "id={$this->request['id']}" 
        ));
        $query = $this->DB->execute();

        if ( ! $Data = $this->DB->fetch($query) ){
            $this->registry->getClass('output')->showError("Unable to find the custom block");
        }
        
        $this->registry->output->html .= $this->html->start_form( array(
            1 => array( 'do'            , 'do_edit_custom_block'    ),
            2 => array( 'module'        , 'uportal'                 ),
            3 => array( 'section'       , 'uportal'                 ),
            4 => array( 'id'            , $this->request['id']      ),
        ) );

        //+-------------------------------

        $this->html->td_header[] = array( "&nbsp;"  , "40%" );
        $this->html->td_header[] = array( "&nbsp;"  , "60%" );

        //+-------------------------------

        $this->registry->output->html .= $this->html->start_table( "Edit Custom Blocks" );
        
        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Block Title:</b><div class='desctext'>This is the title of the block that's shown on the site</div>" ,
        $this->registry->getClass('output')->formInput( "block_title", $Data['title']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Block PHP/HTML:</b><div class='desctext'>Be sure to put the php code in between the &lt;?php and ?&gt; tags</div>",
        $this->registry->getClass('output')->formTextarea("block_html", htmlspecialchars($Data['html']), "70","30")
        ),"","top");
         
        $this->registry->output->html .= $this->html->end_form('Edit Custom Block');
         
        $this->registry->output->html .= $this->html->end_table();
    }
    
    function do_edit_custom_block()
    {
        $blockhtml = stripslashes($_POST['block_html']);
        
        $this->DB->update( 'unrealportal', array( 'title' => $this->request['block_title'] ), "custblock_id={$this->request['id']}" );
        $this->DB->update( 'up_custblocks', array( 'title' => $this->request['block_title'], 'html' => $blockhtml ), "id={$this->request['id']}" );
        
        
        $this->cache();
        
        $this->DB->optimize( 'up_custblocks' );

        $this->registry->output->global_message = "Custom Block Edited";
        $this->edit_del_custom_blocks();
    }
    
    function delete_custom_block()
    {
        $this->DB->delete("unrealportal", "custblock_id={$this->request['id']}");
        $this->DB->delete("up_custblocks", "id={$this->request['id']}");

        $this->cache();
        
        $this->registry->output->global_message = "Custom Block Deleted";
        $this->edit_del_custom_blocks();
    }
    
    function add_custom_content()
    {
        $base_content_html = <<<EOF

<table class='ipb_table' cellspacing="1">
    <tbody>
        <tr>
            <td class='row2'>

<!-- This is the default custom content template. You can either replace this comment tag with your own content to create a simple custom block or you can remove the entire content and have your own formatting-->

            </td>
        </tr>
    </tbody>
</table>
EOF;

        $this->registry->output->html .= $this->html->section_title("Add Custom Content");

        $this->registry->output->html .= $this->html->start_form( array(
            1 => array( 'do'            , 'do_add_custom_content'           ),
            2 => array( 'module'        , 'uportal'                         ),
            3 => array( 'section'       , 'uportal'                         ),
            5 => array( 'content_title' , $this->request['content_title']   ),
            6 => array( 'content_html'  , $this->request['content_html']    ),
        ) );

        //+-------------------------------

        $this->html->td_header[] = array( "&nbsp;"  , "40%" );
        $this->html->td_header[] = array( "&nbsp;"  , "60%" );

        //+-------------------------------

        $this->registry->output->html .= $this->html->start_table( "Add Content" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Content Title:</b><div class='desctext'>This is the title of the content that's shown on the site</div>" ,
        $this->registry->getClass('output')->formInput( "content_title" )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Content PHP/HTML:</b><div class='desctext'>Be sure to put the php code in between the &lt;?php and ?&gt; tags</div>" ,
        $this->registry->getClass('output')->formTextarea("content_html", $base_content_html, "70", "30" )
        ),"","top");
         
        $this->registry->output->html .= $this->html->end_form('Add Content');

        $this->registry->output->html .= $this->html->end_table();
    }
    
    function do_add_custom_content()
    {
        $contenthtml = stripslashes($_POST['content_html']);
        
        $this->DB->insert( 'up_custcontent', array( 'title' => $this->request['content_title'], 'html' => $contenthtml ) );

        $this->cache();

        $this->registry->output->global_message = "Custom Content Added";
        $this->add_custom_content();
    }
      
    function edit_del_custom_content()
    {
        $this->registry->output->html .= $this->html->section_title("Edit/Delete Custom Content");

        //+-------------------------------

        $this->html->td_header[] = array( "Title"   , "34%" );
        $this->html->td_header[] = array( "Edit"    , "33%" );
        $this->html->td_header[] = array( "Delete"  , "33%" );

        //+-------------------------------

        $this->registry->output->html .= $this->html->start_table( "Edit/Delete Custom Content" );

        $i=0;
        
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_custcontent' 
        ));
        $query = $this->DB->execute();

        while( $Data = $this->DB->fetch($query) )
        {
            $i++;

            $this->registry->output->html .= $this->html->add_td_row( array(
                                                          "<center><b>{$Data['title']}</b></center>",
                                                          "<center><a href='{$this->settings['base_url']}module=uportal&section=uportal&do=edit_custom_content&id={$Data['id']}'>Edit</a></center>",
                                                          "<center><a href='{$this->settings['base_url']}module=uportal&section=uportal&do=delete_custom_content&id={$Data['id']}'>Delete</a></center>",
            )      );
        }

        $this->registry->output->html .= $this->html->end_table();
    }
    
    function edit_custom_content()
    {
        $this->registry->output->html .= $this->html->section_title("Edit Custom Content");
        
        $this->DB->build( array( 
            'select'    => '*',
            'from'      => 'up_custcontent',
            'where'     => "id={$this->request['id']}" 
        ));
        $query = $this->DB->execute();

        if ( ! $Data = $this->DB->fetch($query) ){
            $this->registry->getClass('output')->showError("Unable to find the custom content");
        }
        
        $this->registry->output->html .= $this->html->start_form( array(
            1 => array( 'do'            , 'do_edit_custom_content'  ),
            2 => array( 'module'        , 'uportal'                 ),
            3 => array( 'section'       , 'uportal'                 ),
            4 => array( 'id'            , $this->request['id']      ),
        ) );

        //+-------------------------------

        $this->html->td_header[] = array( "&nbsp;"  , "40%" );
        $this->html->td_header[] = array( "&nbsp;"  , "60%" );

        //+-------------------------------

        $this->registry->output->html .= $this->html->start_table( "Edit Custom Content" );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Content Title:</b><div class='desctext'>This is the title of the content that's shown on the site</div>" ,
        $this->registry->getClass('output')->formInput( "content_title", $Data['title']  )
        )      );

        $this->registry->output->html .= $this->html->add_td_row( array( "<b>Content PHP/HTML:</b><div class='desctext'>Be sure to put the php code in between the &lt;?php and ?&gt; tags</div>",
        $this->registry->getClass('output')->formTextarea("content_html", htmlspecialchars($Data['html']), "70", "30")
        ),"","top");
         
        $this->registry->output->html .= $this->html->end_form('Edit Custom Content');
         
        $this->registry->output->html .= $this->html->end_table();
    }
    
    function do_edit_custom_content()
    {
        $contenthtml = stripslashes($_POST['content_html']);

        $this->DB->update( 'up_custcontent', array( 'title' => $this->request['content_title'], 'html' => $contenthtml ), "id={$this->request['id']}" );

        $this->cache();

        $this->DB->optimize( 'up_custcontent' );

        $this->registry->output->global_message = "Custom Content Edited";
        $this->edit_del_custom_content();
    }
    
    function delete_custom_content()
    {
        $this->DB->delete("up_custcontent", "id={$this->request['id']}");

        $this->cache();

        $this->registry->output->global_message = "Custom Content Deleted";
        $this->edit_del_custom_content();
    }
    
    function cache()
    {
        $this->getCache('up_settings', 'uportal_settings');
        $this->getCache('unrealportal', 'uportal_blocks', 'order2 asc');
        $this->getCache('up_custblocks', 'uportal_custblocks');
        $this->getCache('up_custcontent', 'uportal_content');
    }
    
    function getCache($table_name, $settings_name, $order="")
    {
        $cache = array();

        if($order=="")
        {
            $this->DB->build( array( 
                'select'    => '*',
                'from'      => $table_name 
            ));
        }
        else
        {
            $this->DB->build( array( 
                'select'    => '*',
                'from'      => $table_name,
                'order'     => $order
            ));            
        }
        
        $query = $this->DB->execute();
        
        while( $fetch = $this->DB->fetch($query) )
            $cache[] = $fetch;
            
        $this->registry->cache()->setCache( $settings_name, $cache, array( 'array' => 1, 'deletefirst' => 1, 'donow' => 1 ) );
    }
}

?>